#ifndef _MAIN_FRM_H_
#define _MAIN_FRM_H_

#define SECOND 1000
#define WAIT(x) Sleep((long)(x));
#define PI 3.141592653589793

#include <afxwin.h>
#include <algorithm>
#include <vector>
#include <cmath>


class CMainFrm : public CFrameWnd {
public:
	CMainFrm();
	~CMainFrm();
	afx_msg void OnPaint();
	CString m_sPolygonName; 
	CString m_sPolygonFigureName;
	void DrawRegularPolygon( CDC *pDC );
	void DrawStarFigure( CDC *pDC );
	void SuperposeStarFigure( CDC *pDC );
	void FindPolygonName( int p );
	void FindStarFigureName( int p, int q );
	void SetPolygonType( int nType );
	void SetPolygonDrawing( int bDraw );
	void SetNumOfSides( int nSides );
	void SetDefaultTimer( int bVal );
	void SetTimerVal( float nTimerVal );
	void SetDensity( int nDensity );
	afx_msg void OnFileNewPolygon();
	afx_msg void OnHelpAbout();
	afx_msg void OnExit();
	DECLARE_MESSAGE_MAP()
private:
	static INT m_nDensity;
	static INT m_nPolygonType;
	static INT m_nNumOfSides;
	static FLOAT m_fTimerVal;
	static BOOL m_bUpdate;
	static BOOL m_bNoTimer;
	static BOOL m_bDrawPolygon;
	static BOOL m_bDefaultTimer;
};


struct _Polygon {
	int numOfSide; // number of sides
	char *name; // polygon name
};

struct _PolygonFigure {
	int p; // number of sides
	int q; // density
	char *name; // figure name
};


#endif

